/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.element.Button;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSlider<T>
extends Button
implements IField<T, AbstractSlider<T>> {
    private float min;
    private float max;
    private float value;
    @NotNull
    private IField.IChangeCallback<T> action = IField.IChangeCallback::none;
    @Nullable
    private Function<AbstractSlider<T>, Component> textFunc;
    @Nullable
    private Function<AbstractSlider<T>, Tooltip> tooltipFunc;

    public AbstractSlider(int x, int y, float min, float max, T value) {
        super(x, y);
        this.min = min;
        this.max = max;
        this.value = AbstractSlider.convertFromRange(this.valueToFloat(value), min, max);
    }

    protected abstract float valueToFloat(T var1);

    protected abstract T floatToValue(float var1);

    @Override
    public AbstractSlider<T> onChange(@NotNull IField.IChangeCallback<T> action) {
        this.action = action;
        return this;
    }

    public AbstractSlider<T> setTextFormat(@NotNull Function<AbstractSlider<T>, Component> formatter) {
        this.textFunc = formatter;
        this.getStyle().setText(formatter.apply(this));
        return this;
    }

    public AbstractSlider<T> setTooltipFormat(@NotNull Function<AbstractSlider<T>, Tooltip> formatter) {
        this.tooltipFunc = formatter;
        this.getStyle().setTooltip(formatter.apply(this));
        return this;
    }

    @Override
    public AbstractSlider<T> setValue(T value) {
        this.setClampedValue(AbstractSlider.convertFromRange(this.valueToFloat(value), this.min, this.max));
        return this;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93623_ && this.f_93624_ && (keyCode == 263 || keyCode == 262)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            float step = (this.max - this.min) / 4.0f;
            if (keyCode == 263) {
                step *= -1.0f;
            }
            this.setClampedValue(this.value + step);
            this.m_5691_();
            return true;
        }
        return false;
    }

    protected void setClampedValue(float value) {
        if ((value = Mth.m_14036_((float)value, (float)0.0f, (float)1.0f)) != this.value) {
            float initial = this.value;
            this.value = value;
            this.value = AbstractSlider.convertFromRange(this.valueToFloat(this.action.perform(this.getValue())), this.min, this.max);
            if (this.value != initial) {
                if (this.textFunc != null) {
                    this.getStyle().setText(this.textFunc.apply(this));
                }
                if (this.tooltipFunc != null) {
                    this.getStyle().setTooltip(this.tooltipFunc.apply(this));
                }
            }
        }
    }

    private void onChange(double mouseX) {
        this.setClampedValue((float)(mouseX - (double)(this.f_93620_ + 4)) / (float)(this.f_93618_ - 8));
    }

    @Override
    public T getValue() {
        return this.floatToValue(AbstractSlider.convertToRange(this.value, this.min, this.max));
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.onChange(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double mouseDX, double mouseDY) {
        this.onChange(mouseX);
    }

    protected void m_7906_(PoseStack matrices, Minecraft mc, int mouseX, int mouseY) {
        mc.m_91097_().m_174784_(f_93617_);
        int i = 46 + (this.m_198029_() ? 2 : 1) * 20;
        int sliderX = this.f_93620_ + (int)(this.value * (float)(this.f_93618_ - 8));
        this.m_93228_(matrices, sliderX, this.f_93621_, 0, i, 4, 20);
        this.m_93228_(matrices, sliderX + 4, this.f_93621_, 196, i, 4, 20);
    }

    protected int m_7202_(boolean mouseOver) {
        return 0;
    }

    static float convertFromRange(float value, float min, float max) {
        return (Mth.m_14036_((float)value, (float)min, (float)max) - min) / (max - min);
    }

    static float convertToRange(float value, float min, float max) {
        return Mth.m_14036_((float)(min + value * (max - min)), (float)min, (float)max);
    }
}

